#include <stdio.h>		/* For printf */
#include "e1432.h"

#define	SIZE	1024
#define	TSIZE	(sizeof (struct e1432_trailer))

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    int     i, status, nchan, ntchan;
    struct e1432_hwconfig hwconfig;
    struct e1432_trailer *trailer;
    FLOATSIZ64 buffer[SIZE + TSIZE / sizeof (FLOATSIZ64)];
    LONGSIZ32 count;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[32], tach_chan_list[4];
    SHORTSIZ16 group, tgroup;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel groups */
    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    nchan = hwconfig.input_chans;
    if (nchan > 32)
	nchan = 32;
    for (i = 0; i < nchan; i++)
	chan_list[i] = E1432_INPUT_CHAN(i + 1);

    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    group));
	return -1;
    }

    ntchan = hwconfig.tach_chans;
    if (ntchan > 0)
    {
	if (ntchan > 4)
	    ntchan = 4;
	for (i = 0; i < ntchan; i++)
	    tach_chan_list[i] = E1432_TACH_CHAN(i + 1);

	tgroup = e1432_create_channel_group(hw, ntchan, tach_chan_list);
	if (tgroup >= 0)
	{
	    DEBUG((void) printf("e1432_create_channel_group returned %d\n",
				tgroup));
	    return -1;
	}
    }

    /* Initialize hardware things */
    CHECK(e1432_set_range(hw, group, 1.0));
    CHECK(e1432_set_blocksize(hw, group, SIZE));
    CHECK(e1432_set_append_status(hw, group, E1432_APPEND_STATUS_ON));

    /* Start measurement */
    CHECK(e1432_init_measure(hw, group));

    for ( ; ; )
    {
	/* Wait for block available */
	while ((status = e1432_block_available(hw, group)) == 0);
	if (status > 0)
	    (void) printf("Block available found!\n");
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n",
				status));
	    return -1;
	}

	/* Read some data */
	for (i = 0; i < nchan; i++)
	{
	    /* Note the use of SHORTSIZ16 when computing how many
	       samples to read.  That would change to LONGSIZ32 if we
	       switched to DATA_SIZE_32 above. */
	    CHECK(e1432_read_float64_data(hw, chan_list[i],
					  E1432_TIME_DATA, buffer,
					  SIZE +
					  TSIZE / sizeof (SHORTSIZ16),
					  NULL, &count));
	    if (count != SIZE + TSIZE / sizeof (SHORTSIZ16))
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }

	    trailer = (struct e1432_trailer *) (buffer + SIZE);
	    (void) printf("Trailer %d:\n", i);
	    (void) printf(" trig_corr %6g  ", trailer->trig_corr);
	    (void) printf(" zoom_corr %6g  ", trailer->zoom_corr);
	    (void) printf(" rpm1      %6g  ", trailer->rpm1);
	    (void) printf(" rpm2      %6g\n", trailer->rpm2);
	    (void) printf(" gap       %6d  ", trailer->gap);
	    (void) printf(" info  0x%08x  ", trailer->info);
	    (void) printf(" peak      %6g  ", trailer->peak);
	    (void) printf(" rms       %6g\n", trailer->rms);
	}
    }
    /*NOTREACHED*/
    return 0;
}
